<?php

App::uses('AppController', 'Controller');

class ApiController extends AppController
{
    public $uses = array('User', 'Link');
    public $components = array('RequestHandler');
    public $layout = null;

    /**
     *
     */
    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow(array('shorten', 'lookup'));
        if (isset($this->Security)) {
            $this->Security->unlockedActions = array('shorten', 'lookup');
        }

        if (in_array($this->request->action, array('shorten', 'lookup'))) {
            if ($this->request->is(array('post', 'put'))) {
                if ($this->Auth->user('account_type') == 'Demo') {
                    $this->Flash->set(__('This request is disabled into demo.'), array(
                        'element' => 'error'
                    ));
                    return $this->redirect($this->referer());
                }
            }
        }
    }

    public function isAuthorized($user = null)
    {
        return parent::isAuthorized($user);
    }

    /**
     *
     */
    public function shorten()
    {
        $link_data = array();
        if ($this->request->is('post')) {
            $username = (!empty($this->request->data['username']) ? $this->request->data['username'] : '');
            $api_key = (!empty($this->request->data['api_key']) ? $this->request->data['api_key'] : '');

            $login_data = array(
                'username' => $username,
                'api_key' => $api_key
            );

            $api_user = $this->User->api_authenticate($login_data);
            if ($api_user) {
                $user_plan = $this->User->Plan->findById($api_user['User']['plan_id']);
                if ($user_plan['Plan']['api']) {
                    $api_calls = $this->Activity->find('count', array(
                        'conditions' => array(
                            'Activity.user_id' => $api_user['User']['id'],
                            'Activity.type' => 'api',
                            'Activity.created > DATE_SUB(NOW(), INTERVAL 1 DAY)'
                        )
                    ));

                    if ($api_calls < Configure::read('Option.api_usage_limit')) {
                        $activity_data = array(
                            'user_id' => $api_user['User']['id'],
                            'type' => 'api',
                            'action' => 'shorten',
                        );
                        $this->Activity->save($activity_data);

                        $long_url = (!empty($this->request->data['long_url']) ? $this->request->data['long_url'] : '');
                        $alias = (!empty($this->request->data['alias']) ? $this->request->data['alias'] : $this->Link->geturl());

                        $data = array();
                        $data['Link']['user_id'] = $api_user['User']['id'];
                        $data['Link']['bundle_id'] = 0;
                        $data['Link']['ip'] = get_ip();
                        $data['Link']['long_url'] = $long_url;
                        $data['Link']['alias'] = $alias;

                        App::uses('HtmlHelper', 'View/Helper');
                        $html = new HtmlHelper(new View());

                        $long_url_exist = $this->Link->originalLinkExist($long_url);
                        if ($long_url_exist) {
                            $link_data['Link']['long_url'] = $long_url;
                            $link_data['Link']['alias'] = $long_url_exist['Link']['alias'];
                            $link_data['Link']['short_url'] = $html->url('/' . $long_url_exist['Link']['alias'], true);
                            $link_data['Link']['title'] = $long_url_exist['Link']['title'];
                            $link_data['Link']['description'] = $long_url_exist['Link']['description'];
                            $link_data['Link']['clicks'] = $long_url_exist['Link']['clicks'];
                            $link_data['Link']['updated'] = $long_url_exist['Link']['updated'];
                            $link_data['Link']['created'] = $long_url_exist['Link']['created'];

                            $status = 'success';
                            $message = 'Link is already exists.'; // Link is already exists.
                        } else {
                            $this->Link->create();
                            if ($this->Link->save($data)) {
                                $saved_link = $this->Link->findById($this->Link->id);
                                $link_data['Link']['long_url'] = $saved_link['Link']['long_url'];
                                $link_data['Link']['alias'] = $saved_link['Link']['alias'];
                                $link_data['Link']['short_url'] = $html->url('/' . $saved_link['Link']['alias'], true);
                                $link_data['Link']['title'] = $saved_link['Link']['title'];
                                $link_data['Link']['description'] = $saved_link['Link']['description'];
                                $link_data['Link']['clicks'] = $saved_link['Link']['clicks'];
                                $link_data['Link']['updated'] = $long_url_exist['Link']['updated'];
                                $link_data['Link']['created'] = $saved_link['Link']['created'];

                                $status = 'success';
                                $message = 'link has been saved';
                            } else {
                                $status = 'error';
                                $message = $this->Link->validationErrors;
                            }
                        }
                    } else {
                        $status = 'error';
                        $message = 'You have exceeded the monthly api usage limit';
                    }
                } else {
                    $status = 'error';
                    $message = 'Your plan doesn\'t has API access';
                }
            } else {
                $status = 'error';
                $message = 'Invalid login credentials.';
            }
        } else {
            $status = 'error';
            $message = 'Only Post request is allowed';
        }

        $this->set(array(
            'data' => $link_data,
            'status' => $status,
            'message' => $message,
            '_serialize' => array('data', 'status', 'message')
        ));
    }

    /**
     *
     */
    public function lookup()
    {
        $link_data = array();
        if ($this->request->is('post')) {
            $username = (!empty($this->request->data['username']) ? $this->request->data['username'] : '');
            $api_key = (!empty($this->request->data['api_key']) ? $this->request->data['api_key'] : '');

            $login_data = array(
                'username' => $username,
                'api_key' => $api_key
            );

            $api_user = $this->User->api_authenticate($login_data);
            if ($api_user) {
                $user_plan = $this->User->Plan->findById($api_user['User']['plan_id']);
                if ($user_plan['Plan']['api']) {
                    $api_calls = $this->Activity->find('count', array(
                        'conditions' => array(
                            'Activity.user_id' => $api_user['User']['id'],
                            'Activity.type' => 'api',
                            'Activity.created > DATE_SUB(NOW(), INTERVAL 1 DAY)'
                        )
                    ));

                    if ($api_calls < Configure::read('Option.api_usage_limit')) {
                        $activity_data = array(
                            'user_id' => $api_user['User']['id'],
                            'type' => 'api',
                            'action' => 'lookup',
                        );
                        $this->Activity->save($activity_data);

                        App::uses('HtmlHelper', 'View/Helper');
                        $html = new HtmlHelper(new View());

                        $long_url = (!empty($this->request->data['long_url']) ? $this->request->data['long_url'] : '');

                        $link = $this->Link->find('first', array(
                            'fields' => array(
                                'Link.long_url',
                                'Link.alias',
                                'Link.title',
                                'Link.description',
                                'Link.clicks',
                                'Link.updated',
                                'Link.created'
                            ),
                            'conditions' => array('Link.long_url' => $long_url, 'Link.user_id' => $api_user['User']['id']),
                        ));

                        if ($link) {
                            $link_data = $link;
                            $link_data['Link']['short_url'] = $html->url('/' . $link['Link']['alias'], true);
                            $status = 'success';
                            $message = 'Success';
                        } else {
                            $status = 'error';
                            $message = 'Not Found';
                        }
                    } else {
                        $status = 'error';
                        $message = 'You have exceeded the monthly api usage limit';
                    }
                } else {
                    $status = 'error';
                    $message = 'Your plan doesn\'t has API access';
                }
            } else {
                $status = 'error';
                $message = 'Invalid login credentials.';
            }
        } else {
            $status = 'error';
            $message = 'Only Post request is allowed';
        }

        $this->set(array(
            'data' => $link_data,
            'status' => $status,
            'message' => $message,
            '_serialize' => array('data', 'status', 'message')
        ));
    }
}
